using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Drawing.Imaging;
using System.Runtime.InteropServices;
using System.Text;
using System.Windows.Forms;
using Pinvoke;

namespace TestAvicap32
{

    

    public partial class Form1 : Form
    {

        int zaehler = 0;

        public Form1()
        {
            InitializeComponent();
            InitializeDevicesList();
        }

        public event EventHandler<ColorEvent> colevt;

        private void InitializeDevicesList()
        {

            foreach (CaptureDevice device in CaptureDevice.GetDevices())
            {
                cboDevices.Items.Add(device);
            }

            if (cboDevices.Items.Count > 0)
            {
                cboDevices.SelectedIndex = 0;
            }
        }

        private void btnStart_Click(object sender, EventArgs e)
        {
            int index = cboDevices.SelectedIndex;
            if (index != -1)
            {

                ((CaptureDevice)cboDevices.SelectedItem).Attach(pictureBox1);
                
                // Hier einstellen, wie hoch die Bildrate ist:

                timer1.Interval = (int) numericUpDown1.Value;
                timer1.Start();


            }
        }

        private void btnStop_Click(object sender, EventArgs e)
        {

            ((CaptureDevice)cboDevices.SelectedItem).Detach();
            timer1.Interval = Convert.ToInt32( numericUpDown1.Value ) ;
            timer1.Stop();
        }







        private void Timer_Tick(object sender, EventArgs e)
        {
            int start_x = Convert.ToInt32( label_start_x.Text);
            int start_y = Convert.ToInt32(label_start_y.Text);
            int size_x = Convert.ToInt32(label_size_x.Text);
            int size_y = Convert.ToInt32(label_size_y.Text);


            Bitmap stream = new Bitmap(((CaptureDevice)cboDevices.SelectedItem).Capture());

            int width = stream.Width;
            int height = stream.Height;

            BitmapData bmpData;
            bmpData = stream.LockBits(new Rectangle(0, 0, width, height), ImageLockMode.ReadWrite, PixelFormat.Format32bppRgb);

            // Hier den Rahmen in das Bild schreiben:

            unsafe
            {
                byte* ptr = (byte*)bmpData.Scan0;

                int rahmen = 5;

                // Rahmen in x-Richtung zeichnen:
                for (int j = 0; j < rahmen; j++)
                {

                    for (int i = 0; i < size_x*4 ; i++)
                    {

                        ptr[4 * start_y * width + j * width * 4 + 4 * start_x + i] = 0;
                        ptr[4 * start_y * width + j * width * 4 + size_y * width * 4 + 4 * start_x + i] = 0;

                     }
                }

                // Rahmen in y-Richtung zeichnen:
                for (int j = 0; j < size_y+5; j++)
                {

                    for (int i = 0; i < rahmen*4; i++)
                    {

                        ptr[4 * start_y * width + j * width * 4 +  4 * start_x +               i ] = 0;
                        ptr[4 * start_y * width + j * width * 4 +  4 * start_x + 4 * size_x +  i] = 0;

                    }
                }
            }
            stream.UnlockBits(bmpData);

            pbImage.Image = stream;

            try
            {
                Bitmap image = new Bitmap(((CaptureDevice)cboDevices.SelectedItem).Capture());

                BitmapData bmpData1;
                bmpData1 = image.LockBits(new Rectangle(0, 0, width, height), ImageLockMode.ReadWrite, PixelFormat.Format32bppRgb);


                unsafe
                {
                    byte* ptr = (byte*)bmpData1.Scan0;


                    int rot = 0;
                    int gruen = 0;
                    int blau = 0;

                    int rot_mittel = 0;
                    int gruen_mittel = 0;
                    int blau_mittel = 0;


                    for (int j = 0; j < size_y; j++)
                    {


                        for (int i = 0; i < size_x; i++)
                        {
                            rot += (int)ptr[4 * start_y * width + j * width * 4 + 4 * start_x + 2 + i * 4];
                            gruen += (int)ptr[4 * start_y * width + j * width * 4 + 4 * start_x + 1 + i * 4];
                            blau += (int)ptr[4 * start_y * width + j * width * 4 + 4 * start_x + 0 + i * 4];

                        }
                    }

                    //Mittelwerte berechnen:

                    rot_mittel = (rot / (size_x * size_y));
                    gruen_mittel = (gruen / (size_x * size_y));
                    blau_mittel = (blau / (size_x * size_y));

                    // Mittelfarbwerte ausgeben:

                    label_rot.Text = rot_mittel.ToString();
                    label_gruen.Text = gruen_mittel.ToString();
                    label_blau.Text = blau_mittel.ToString();

                    // Hintergrundfarbe von PictureBox setzen:

                    pictureBox2.BackColor = Color.FromArgb(rot_mittel, gruen_mittel, blau_mittel);

                    

                }
                image.UnlockBits(bmpData1);

                // Hier wird die Farbe per Event an das Hauptprogramm gesendet.

                colevt(this, new ColorEvent(pictureBox2.BackColor));

               // Hier die Bilder alle 10 Frames wieder lschen!!!


               zaehler ++;

                if (zaehler > 10)
                {
                    GC.Collect();
                    zaehler = 0;

                }

                

                

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString(), "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }

        }

        private void pbImage_MouseDown(object sender, MouseEventArgs e)
        {
            label_start_x.Text = e.Location.X.ToString();
            label_start_y.Text = e.Location.Y.ToString();
        }

        private void pbImage_MouseUp(object sender, MouseEventArgs e)
        {
            label_size_x.Text = (  e.Location.X - Convert.ToInt32(label_start_x.Text)).ToString();
            label_size_y.Text = (e.Location.Y - Convert.ToInt32(label_start_y.Text) ).ToString();
        }

        private void Form1_Load(object sender, EventArgs e)
        {

        }

    }
    public class ColorEvent : EventArgs
    {
        Color color;

        public ColorEvent(Color col)
        {
            color = col;
        }

        public Color Color
        {
            get { return color; }
            set { color = value; }
        }
    }
}